<?php
if (class_exists('ControllerExtensionModuleBdbulksmsNotifications', false)) { return; }
class ControllerExtensionModuleBdbulksmsNotifications extends Controller {
    private $error = array();

    public function index() {
        $this->load->language('extension/module/bdbulksms_notifications');
        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('extension/module/bdbulksms_notifications');
        if (!$this->model_extension_module_bdbulksms_notifications->isInstalled()) {
            $this->install();
            $this->response->redirect($this->url->link('extension/module/bdbulksms_notifications', 'user_token=' . $this->session->data['user_token'], true));
            return;
        }

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->load->model('setting/setting');
            $this->model_setting_setting->editSetting('module_bdbulksms_notifications', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
        }

        $data['breadcrumbs'] = array(
            array('text' => $this->language->get('text_home'), 'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)),
            array('text' => $this->language->get('text_extension'), 'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)),
            array('text' => $this->language->get('heading_title'), 'href' => $this->url->link('extension/module/bdbulksms_notifications', 'user_token=' . $this->session->data['user_token'], true))
        );
        $data['action'] = $this->url->link('extension/module/bdbulksms_notifications', 'user_token=' . $this->session->data['user_token'], true);
        $data['save_ajax'] = $this->url->link('extension/module/bdbulksms_notifications/saveAjax', 'user_token=' . $this->session->data['user_token'], true);
        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
        $data['user_token'] = $this->session->data['user_token'];

        $keys = array('status','token','admin_numbers','new_order_admin_status','new_order_admin_template','new_order_customer_status','new_order_customer_template','order_update_customer_status','order_update_customer_template','customer_login_admin_status','customer_login_admin_template','customer_login_customer_status','customer_login_customer_template','admin_login_admin_status','admin_login_admin_template');
        foreach ($keys as $k) {
            $key = 'module_bdbulksms_notifications_' . $k;
            $data[$key] = $this->config->get($key);
        }

        $data['default_templates'] = array(
            'new_order_admin' => 'New order #{{order_id}} from {{customer_name}}. Total: {{total}}. Site: {{store_name}}',
            'new_order_customer' => 'Dear {{customer_name}}, your order #{{order_id}} is placed. Total: {{total}}.',
            'order_update_customer' => 'Dear {{customer_name}}, your order #{{order_id}} status has been updated to {{order_status}}.',
            'customer_login_admin' => 'Login: {{customer_name}} ({{email}}) at {{datetime}}. IP: {{ip}}',
            'customer_login_customer' => 'Dear {{customer_name}}, you logged in to {{store_name}} at {{datetime}}.',
            'admin_login_admin' => 'Admin {{admin_name}} logged in to {{store_name}} at {{datetime}}. IP: {{ip}}'
        );

        $data['current_balance'] = '';
        if (!empty($data['module_bdbulksms_notifications_token'])) {
            $this->load->library('bdbulksms_notifications_sms');
            $sms = new bdbulksms_notifications_sms($this->registry);
            $b = $sms->checkBalance($data['module_bdbulksms_notifications_token']);
            if ($b && isset($b[0]['response'])) $data['current_balance'] = $b[0]['response'] . ' SMS';
        }

        // Logs
        $data['sms_logs'] = $this->model_extension_module_bdbulksms_notifications->getLogs(50);

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');
        $this->response->setOutput($this->load->view('extension/module/bdbulksms_notifications', $data));
    }

    public function saveAjax() {
        $this->load->language('extension/module/bdbulksms_notifications');
        $json = array();
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->load->model('setting/setting');
            $this->model_setting_setting->editSetting('module_bdbulksms_notifications', $this->request->post);
            $json['success'] = $this->language->get('text_success');
        } else {
            $json['error'] = $this->error['warning'] ?? 'Invalid data';
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function testApi() {
        $json = array();
        $token = $this->request->post['token'] ?? '';
        if ($token) {
            $this->load->library('bdbulksms_notifications_sms');
            $sms = new bdbulksms_notifications_sms($this->registry);
            $result = $sms->checkBalance($token);
            if ($result && isset($result[0]['response'])) $json['success'] = 'API Connection successful! Balance: ' . $result[0]['response'] . ' SMS';
            else $json['error'] = 'API Connection failed. Please check your token.';
        } else {
            $json['error'] = 'Please enter API token first.';
        }
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }

    public function clearLogs() {
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->clearLogs();
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode(['success' => 'SMS logs cleared successfully.']));
    }

public function eventAdminLogin(&$route = '', &$args = array(), &$output = null) {
    $this->load->model('extension/module/bdbulksms_notifications');
    // Call the admin model's handler so Proxy has a bound method
    $this->model_extension_module_bdbulksms_notifications->handleEvent('admin/controller/common/login/after', $args);
}


    public function install() {
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->install();
        $this->load->model('setting/event');
        foreach (['new_order','order_status','admin_login','customer_login'] as $code) {
            $this->model_setting_event->deleteEventByCode('bdbulksms_notifications_' . $code);
        }
        // Events point to catalog controller endpoint
        $this->model_setting_event->addEvent('bdbulksms_notifications_new_order', 'catalog/model/checkout/order/addOrder/after', 'extension/module/bdbulksms_notifications/onEvent');
        $this->model_setting_event->addEvent('bdbulksms_notifications_order_status', 'catalog/model/checkout/order/addOrderHistory/after', 'extension/module/bdbulksms_notifications/onEvent');
        $this->model_setting_event->addEvent('bdbulksms_notifications_admin_login', 'admin/controller/common/login/after', 'extension/module/bdbulksms_notifications/onEvent');
        $this->model_setting_event->addEvent('bdbulksms_notifications_customer_login', 'catalog/controller/account/login/after', 'extension/module/bdbulksms_notifications/onEvent');
    }

    public function uninstall() {
        $this->load->model('setting/event');
        foreach (['new_order','order_status','admin_login','customer_login'] as $code) {
            $this->model_setting_event->deleteEventByCode('bdbulksms_notifications_' . $code);
        }
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->uninstall();
    }

    private function validate() {
        if (!$this->user->hasPermission('modify', 'extension/module/bdbulksms_notifications')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        return !$this->error;
    }

    // Back-compat wrappers for old injected calls (admin context)
    public function eventNewOrder(&$route = '', &$args = array(), &$output = null) {
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->handleEvent('catalog/model/checkout/order/addOrder/after', $args);
    }
    public function eventOrderStatusUpdate(&$route = '', &$args = array(), &$output = null) {
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->handleEvent('catalog/model/checkout/order/addOrderHistory/after', $args);
    }
  
    public function eventCustomerLogin(&$route = '', &$args = array(), &$output = null) {
        $this->load->model('extension/module/bdbulksms_notifications');
        $this->model_extension_module_bdbulksms_notifications->handleEvent('catalog/controller/account/login/after', $args);
    }
}
?>
