<?php
namespace Opencart\Admin\Model\Extension\Greenweb\Module;

class BdbulksmsNotifications extends \Opencart\System\Engine\Model {
    public function install(): void {
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "bdbulksms_notifications_logs` (
            `log_id` int(11) NOT NULL AUTO_INCREMENT,
            `phone` varchar(50) NOT NULL,
            `message` text NOT NULL,
            `status` varchar(20) NOT NULL,
            `response` text NOT NULL,
            `date_added` datetime NOT NULL,
            PRIMARY KEY (`log_id`)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        $this->load->model('setting/setting');
        $defaults = [
            'module_bdbulksms_notifications_status' => '1',
            'module_bdbulksms_notifications_token' => '',
            'module_bdbulksms_notifications_admin_numbers' => '',
            'module_bdbulksms_notifications_new_order_admin_status' => '1',
            'module_bdbulksms_notifications_new_order_customer_status' => '1',
            'module_bdbulksms_notifications_order_update_customer_status' => '1',
            'module_bdbulksms_notifications_customer_login_admin_status' => '0',
            'module_bdbulksms_notifications_customer_login_customer_status' => '0',
            'module_bdbulksms_notifications_admin_login_admin_status' => '1',
            'module_bdbulksms_notifications_new_order_admin_template' => 'New order #{{order_id}} from {{customer_name}}. Total: {{total}}. Site: {{store_name}}',
            'module_bdbulksms_notifications_new_order_customer_template' => 'Dear {{customer_name}}, your order #{{order_id}} is placed. Total: {{total}}.',
            'module_bdbulksms_notifications_order_update_customer_template' => 'Dear {{customer_name}}, your order #{{order_id}} status has been updated to {{order_status}}.',
            'module_bdbulksms_notifications_customer_login_admin_template' => 'Login: {{customer_name}} ({{email}}) at {{datetime}}. IP: {{ip}}',
            'module_bdbulksms_notifications_customer_login_customer_template' => 'Dear {{customer_name}}, you logged in to {{store_name}} at {{datetime}}.',
            'module_bdbulksms_notifications_admin_login_admin_template' => 'Admin {{admin_name}} logged in to {{store_name}} at {{datetime}}. IP: {{ip}}'
        ];
        $this->model_setting_setting->editSetting('module_bdbulksms_notifications', $defaults);
    }

    public function uninstall(): void {
        $this->db->query("DELETE FROM `" . DB_PREFIX . "setting` WHERE `code`='module_bdbulksms_notifications'");
    }

    public function isInstalled(): bool {
        $q = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "bdbulksms_notifications_logs'");
        return (bool)$q->num_rows;
    }

    public function addLog(string $phone, string $message, string $status, string $response): void {
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "bdbulksms_notifications_logs` (
            `log_id` int(11) NOT NULL AUTO_INCREMENT,
            `phone` varchar(50) NOT NULL,
            `message` text NOT NULL,
            `status` varchar(20) NOT NULL,
            `response` text NOT NULL,
            `date_added` datetime NOT NULL,
            PRIMARY KEY (`log_id`)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        $this->db->query("INSERT INTO " . DB_PREFIX . "bdbulksms_notifications_logs SET
            phone = '" . $this->db->escape($phone) . "',
            message = '" . $this->db->escape($message) . "',
            status = '" . $this->db->escape($status) . "',
            response = '" . $this->db->escape($response) . "',
            date_added = NOW()");
    }

    public function getLogs(int $limit = 50): array {
        $exists = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "bdbulksms_notifications_logs'");
        if (!$exists->num_rows) return [];
        $q = $this->db->query("SELECT * FROM " . DB_PREFIX . "bdbulksms_notifications_logs ORDER BY date_added DESC LIMIT " . (int)$limit);
        return $q->rows;
    }

    public function clearLogs(): void {
        $this->db->query("DELETE FROM " . DB_PREFIX . "bdbulksms_notifications_logs");
    }

    // Admin-only handler
    public function handleEvent(string $route, array $args = []): void {
        if ($route !== 'admin/controller/common/login/after') return;
        if (!$this->config->get('module_bdbulksms_notifications_status')) return;
        if (!$this->config->get('module_bdbulksms_notifications_admin_login_admin_status')) return;

        $this->load->library('bdbulksms_notifications_sms');
        $sms = new \bdbulksms_notifications_sms($this->registry);

        $admin_name = (isset($this->user) && method_exists($this->user, 'getUserName')) ? ($this->user->getUserName() ?? 'Admin') : 'Admin';
        $info = [
            'admin_name' => $admin_name,
            'datetime' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
            'store_name' => $this->config->get('config_name'),
            'store_url' => $this->config->get('config_url')
        ];
        $tpl = $this->config->get('module_bdbulksms_notifications_admin_login_admin_template');
        $msg = $this->parseTemplateAdmin($tpl, $info);
        $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
        foreach ($numbers as $n) {
            $n = trim($n);
            if ($n) $sms->send($n, $msg, 'admin_login_admin');
        }
    }

    private function parseTemplateAdmin(string $template, array $data): string {
        $find = []; $replace = [];
        foreach ($data as $k => $v) { $find[]='{{'.$k.'}}'; $replace[]=$v; $find[]='{'.$k.'}'; $replace[]=$v; }
        return str_replace($find, $replace, (string)$template);
    }
}
