<?php
namespace Opencart\Catalog\Model\Extension\Greenweb\Module;

class BdbulksmsNotifications extends \Opencart\System\Engine\Model {
    private static array $once = [];
    private function once(string $key): bool { if (isset(self::$once[$key])) return false; self::$once[$key]=true; return true; }

    public function handleEvent(string $route, array $args): void {
        if (!$this->config->get('module_bdbulksms_notifications_status')) return;

        $this->load->library('bdbulksms_notifications_sms');
        $sms = new \bdbulksms_notifications_sms($this->registry);

        if ($route === 'catalog/model/checkout/order.addOrder/after') { $oid=$args[0]??0; if($oid){$this->handleNewOrder($sms,[$oid]);} return; }
        if ($route === 'catalog/model/checkout/order.addHistory/after') { $oid=$args[0]??0; $sid=$args[1]??0; if($oid&&$sid){$this->handleOrderStatusUpdate($sms,[$oid,$sid]);} return; }
        if ($route === 'admin/controller/common/login/after') { $this->handleAdminLogin($sms); return; }
        if ($route === 'catalog/model/account/customer/login/after' || $route === 'catalog/controller/account/login/after') {
            if ($this->customer && $this->customer->isLogged()) { $k='cust_login:'.(int)$this->customer->getId(); if(!$this->once($k)) return; }
            $this->handleCustomerLogin($sms); return;
        }
    }

    private function handleNewOrder($sms, $args): void {
        $order_id = $args[0] ?? 0; if (!$order_id) return;
        $this->load->model('checkout/order'); $order_info = $this->model_checkout_order->getOrder($order_id); if (!$order_info) return;

        if ($this->config->get('module_bdbulksms_notifications_new_order_customer_status') && !empty($order_info['telephone'])) {
            $tpl = $this->config->get('module_bdbulksms_notifications_new_order_customer_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            $sms->send($order_info['telephone'], $msg, 'new_order_customer');
        }
        if ($this->config->get('module_bdbulksms_notifications_new_order_admin_status')) {
            $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
            $tpl = $this->config->get('module_bdbulksms_notifications_new_order_admin_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'new_order_admin'); }
        }
    }

    private function handleOrderStatusUpdate($sms, $args): void {
        $order_id = $args[0] ?? 0; $order_status_id = $args[1] ?? 0; if (!$order_id || !$order_status_id) return;
        $this->load->model('checkout/order'); $order_info = $this->model_checkout_order->getOrder($order_id); if (!$order_info) return;

        if ($this->config->get('module_bdbulksms_notifications_order_update_customer_status') && !empty($order_info['telephone'])) {
            $this->load->model('localisation/order_status'); $status = $this->model_localisation_order_status->getOrderStatus($order_status_id);
            $order_info['order_status'] = $status['name'] ?? '';
            $tpl = $this->config->get('module_bdbulksms_notifications_order_update_customer_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            $sms->send($order_info['telephone'], $msg, 'order_update_customer');
        }
    }

    private function handleAdminLogin($sms): void {
        if (!$this->config->get('module_bdbulksms_notifications_admin_login_admin_status')) return;
        $info = ['admin_name'=>'Admin','datetime'=>date('Y-m-d H:i:s'),'ip'=>$_SERVER['REMOTE_ADDR'] ?? 'Unknown','store_name'=>$this->config->get('config_name'),'store_url'=>$this->config->get('config_url')];
        $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
        $tpl = $this->config->get('module_bdbulksms_notifications_admin_login_admin_template'); $msg = $this->parseTemplate($tpl, $info);
        foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'admin_login_admin'); }
    }

    private function handleCustomerLogin($sms): void {
        if (!$this->customer || !$this->customer->isLogged()) return;
        $customer_id = $this->customer->getId();
        $this->load->model('account/customer'); $c = $this->model_account_customer->getCustomer($customer_id); if (!$c) return;
        $data = ['customer_name'=>trim(($c['firstname'] ?? '').' '.($c['lastname'] ?? '')),'email'=>$c['email'] ?? '','phone'=>$c['telephone'] ?? '','datetime'=>date('Y-m-d H:i:s'),'ip'=>$_SERVER['REMOTE_ADDR'] ?? 'Unknown','store_name'=>$this->config->get('config_name'),'store_url'=>$this->config->get('config_url')];
        if ($this->config->get('module_bdbulksms_notifications_customer_login_customer_status') && !empty($c['telephone'])) {
            $tpl = $this->config->get('module_bdbulksms_notifications_customer_login_customer_template'); $sms->send($c['telephone'], $this->parseTemplate($tpl, $data), 'customer_login_customer');
        }
        if ($this->config->get('module_bdbulksms_notifications_customer_login_admin_status')) {
            $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
            $tpl = $this->config->get('module_bdbulksms_notifications_customer_login_admin_template'); $msg = $this->parseTemplate($tpl, $data);
            foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'customer_login_admin'); }
        }
    }

    private function mapOrder(array $o): array {
        return ['order_id'=>$o['order_id'],'customer_name'=>trim(($o['firstname'] ?? '').' '.($o['lastname'] ?? '')),'email'=>$o['email'] ?? '','phone'=>$o['telephone'] ?? '','total'=>$this->currency->format($o['total'],$o['currency_code'],$o['currency_value']),'order_status'=>$o['order_status'] ?? '','store_name'=>$this->config->get('config_name'),'store_url'=>$this->config->get('config_url'),'datetime'=>date('Y-m-d H:i:s'),'ip'=>$_SERVER['REMOTE_ADDR'] ?? 'Unknown'];
    }
    private function parseTemplate(string $template, array $data): string {
        $find=[]; $replace=[]; foreach ($data as $k=>$v){$find[]='{{'.$k.'}}';$replace[]=$v;$find[]='{'.$k.'}';$replace[]=$v;} return str_replace($find,$replace,(string)$template);
    }
}
