<?php
if (class_exists('ModelExtensionModuleBdbulksmsNotifications', false)) { return; }
class ModelExtensionModuleBdbulksmsNotifications extends Model {
 private static $once = array();


    // Add this helper
    private function once($key) {
        if (isset(self::$once[$key])) return false;
        self::$once[$key] = true;
        return true;
    }
    
    public static function triggerEvent($registry, $route, $args = array()) {
    try {
        // Direct instantiation bypasses proxy
        $model = new self($registry);
        $model->handleEvent($route, $args);
    } catch (\Exception $e) {
        // Silent fail to avoid breaking checkout/login
    }
}
    
 public function handleEvent($route, $args) {
        if (!$this->config->get('module_bdbulksms_notifications_status')) return;

        $this->load->library('bdbulksms_notifications_sms');
        $sms = new bdbulksms_notifications_sms($this->registry);

        if ($route == 'catalog/model/checkout/order/addOrder/after') {
            $this->handleNewOrder($sms, $args);
        }

        if ($route == 'catalog/model/checkout/order/addOrderHistory/after') {
            $this->handleOrderStatusUpdate($sms, $args);
        }

        if ($route == 'admin/controller/common/login/after') {
            $this->handleAdminLogin($sms);
        }
        
    if ($route == 'catalog/model/account/customer/login/after'
     || $route == 'catalog/controller/account/login/after'
     || $route == 'library/cart/customer/login/after') {

        if ($this->customer && $this->customer->isLogged()) {
            $ckey = 'cust_login:' . (int)$this->customer->getId();
            if (method_exists($this, 'once')) {
                if (!$this->once($ckey)) return;
            }
        }
        $this->handleCustomerLogin($sms);
        return;
    }     

    }

    private function handleNewOrder($sms, $args) {
        $order_id = $args[0] ?? 0;
        if (!$order_id) return;

        // De-dup per request for this order's "new_order"
        if (!$this->once('new_order:' . (int)$order_id)) return;

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if (!$order_info) return;

        if ($this->config->get('module_bdbulksms_notifications_new_order_customer_status') && !empty($order_info['telephone'])) {
            $tpl = $this->config->get('module_bdbulksms_notifications_new_order_customer_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            $sms->send($order_info['telephone'], $msg, 'new_order_customer');
        }

        if ($this->config->get('module_bdbulksms_notifications_new_order_admin_status')) {
            $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
            $tpl = $this->config->get('module_bdbulksms_notifications_new_order_admin_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'new_order_admin'); }
        }
    }

    private function handleOrderStatusUpdate($sms, $args) {
        $order_id = $args[0] ?? 0;
        $order_status_id = $args[1] ?? 0;
        if (!$order_id || !$order_status_id) return;

        // De-dup per request for this order & status pair
        if (!$this->once('order_update:' . (int)$order_id . ':' . (int)$order_status_id)) return;

        $this->load->model('checkout/order');
        $order_info = $this->model_checkout_order->getOrder($order_id);
        if (!$order_info) return;

        if ($this->config->get('module_bdbulksms_notifications_order_update_customer_status') && !empty($order_info['telephone'])) {
            $this->load->model('localisation/order_status');
            $status = $this->model_localisation_order_status->getOrderStatus($order_status_id);
            $order_info['order_status'] = $status['name'] ?? '';
            $tpl = $this->config->get('module_bdbulksms_notifications_order_update_customer_template');
            $msg = $this->parseTemplate($tpl, $this->mapOrder($order_info));
            $sms->send($order_info['telephone'], $msg, 'order_update_customer');
        }
    }

    private function handleAdminLogin($sms) {
        if (!$this->config->get('module_bdbulksms_notifications_admin_login_admin_status')) return;
        $admin_name = isset($this->user) && method_exists($this->user, 'getUserName') ? ($this->user->getUserName() ?? 'Admin') : 'Admin';
        $info = [
            'admin_name' => $admin_name,
            'datetime' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
            'store_name' => $this->config->get('config_name'),
            'store_url' => $this->config->get('config_url')
        ];
        $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
        $tpl = $this->config->get('module_bdbulksms_notifications_admin_login_admin_template');
        $msg = $this->parseTemplate($tpl, $info);
        foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'admin_login_admin'); }
    }

    private function handleCustomerLogin($sms) {
    if (!$this->customer || !$this->customer->isLogged()) return;

    $customer_id = $this->customer->getId();
    $this->load->model('account/customer');
    $c = $this->model_account_customer->getCustomer($customer_id);
    if (!$c) return;

    $data = [
        'customer_name' => trim(($c['firstname'] ?? '') . ' ' . ($c['lastname'] ?? '')),
        'email'        => $c['email'] ?? '',
        'phone'        => $c['telephone'] ?? '',
        'datetime'     => date('Y-m-d H:i:s'),
        'ip'           => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
        'store_name'   => $this->config->get('config_name'),
        'store_url'    => $this->config->get('config_url')
    ];

    // Send to customer (requires telephone)
    if ($this->config->get('module_bdbulksms_notifications_customer_login_customer_status') && !empty($c['telephone'])) {
        $tpl = $this->config->get('module_bdbulksms_notifications_customer_login_customer_template');
        $sms->send($c['telephone'], $this->parseTemplate($tpl, $data), 'customer_login_customer');
    }

    // Send to admin(s) if enabled
    if ($this->config->get('module_bdbulksms_notifications_customer_login_admin_status')) {
        $numbers = explode(',', (string)$this->config->get('module_bdbulksms_notifications_admin_numbers'));
        $tpl = $this->config->get('module_bdbulksms_notifications_customer_login_admin_template');
        $msg = $this->parseTemplate($tpl, $data);
        foreach ($numbers as $n) { if (trim($n)) $sms->send(trim($n), $msg, 'customer_login_admin'); }
    }
}


    // Shared utils + logging
    public function addLog($phone, $message, $status, $response) {
        $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "bdbulksms_notifications_logs` (
            `log_id` int(11) NOT NULL AUTO_INCREMENT,
            `phone` varchar(50) NOT NULL,
            `message` text NOT NULL,
            `status` varchar(20) NOT NULL,
            `response` text NOT NULL,
            `date_added` datetime NOT NULL,
            PRIMARY KEY (`log_id`)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
        $this->db->query("INSERT INTO " . DB_PREFIX . "bdbulksms_notifications_logs SET
            phone = '" . $this->db->escape($phone) . "',
            message = '" . $this->db->escape($message) . "',
            status = '" . $this->db->escape($status) . "',
            response = '" . $this->db->escape($response) . "',
            date_added = NOW()");
    }

    public function getLogs($limit = 50) {
        $exists = $this->db->query("SHOW TABLES LIKE '" . DB_PREFIX . "bdbulksms_notifications_logs'");
        if (!$exists->num_rows) return array();
        $q = $this->db->query("SELECT * FROM " . DB_PREFIX . "bdbulksms_notifications_logs ORDER BY date_added DESC LIMIT " . (int)$limit);
        return $q->rows;
    }

    public function clearLogs() {
        $this->db->query("DELETE FROM " . DB_PREFIX . "bdbulksms_notifications_logs");
    }

    private function mapOrder($o) {
        return [
            'order_id' => $o['order_id'],
            'customer_name' => trim(($o['firstname'] ?? '') . ' ' . ($o['lastname'] ?? '')),
            'email' => $o['email'] ?? '',
            'phone' => $o['telephone'] ?? '',
            'total' => $this->currency->format($o['total'], $o['currency_code'], $o['currency_value']),
            'order_status' => $o['order_status'] ?? '',
            'store_name' => $this->config->get('config_name'),
            'store_url' => $this->config->get('config_url'),
            'datetime' => date('Y-m-d H:i:s'),
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown'
        ];
    }

    private function parseTemplate($template, $data) {
        // Replace both {{key}} and {key}
        $find = [];
        $replace = [];
        foreach ($data as $k => $v) {
            $find[] = '{{' . $k . '}}';
            $replace[] = $v;
            $find[] = '{' . $k . '}';
            $replace[] = $v;
        }
        return str_replace($find, $replace, (string)$template);
    }
}
?>
