<?php
class bdbulksms_notifications_sms {
    private $registry;
    private $api_url = 'https://api.bdbulksms.net/api.php?json';
    private $balance_url = 'https://api.bdbulksms.net/g_api.php';

    public function __construct($registry) { $this->registry = $registry; }
    public function __get($key) { return $this->registry->get($key); }

    public function send($phone, $message, $type = '') {
        $token = $this->config->get('module_bdbulksms_notifications_token');
        if (empty($token)) {
            $this->logResult($phone, $message, 'FAILED', 'Token not configured');
            return false;
        }

        $phone = $this->clean($phone);
        $post = ['to' => $phone, 'message' => $message, 'token' => $token];

        $resp = $this->req($this->api_url, $post, 'POST');
        if ($resp) {
            $arr = json_decode($resp, true);
            if (is_array($arr)) {
                foreach ($arr as $it) {
                    $status = $it['status'] ?? 'UNKNOWN';
                    $msg = $it['statusmsg'] ?? 'No response';
                    $this->logResult($phone, $message, $status, $msg);
                    return ($status === 'SENT');
                }
            }
        }
        $this->logResult($phone, $message, 'FAILED', 'API request failed');
        return false;
    }

    public function checkBalance($token = null) {
        if (!$token) $token = $this->config->get('module_bdbulksms_notifications_token');
        if (empty($token)) return false;
        $url = $this->balance_url . '?token=' . urlencode($token) . '&balance&json';
        $resp = $this->req($url, null, 'GET');
        return $resp ? json_decode($resp, true) : false;
    }

    private function req($url, $data = null, $method = 'POST') {
        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_USERAGENT => 'OpenCart 3.x BD SMS Extension'
        ]);
        if ($method === 'POST' && $data) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        }
        $resp = curl_exec($ch);
        $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        if ($code !== 200) return false;
        return $resp;
    }

    private function clean($p) {
       return preg_replace('/[^0-9+]/', '', (string)$p);
    }

    private function logResult($phone, $message, $status, $response) {
        // Try model logging
        try {
            $this->load->model('extension/module/bdbulksms_notifications');
            if (isset($this->model_extension_module_bdbulksms_notifications)
                && method_exists($this->model_extension_module_bdbulksms_notifications, 'addLog')) {
                $this->model_extension_module_bdbulksms_notifications->addLog($phone, $message, $status, $response);
                return;
            }
        } catch (\Exception $e) {
            // fall through
        }
        // Direct DB fallback so logs are guaranteed
        try {
            $this->db->query("CREATE TABLE IF NOT EXISTS `" . DB_PREFIX . "bdbulksms_notifications_logs` (
                `log_id` int(11) NOT NULL AUTO_INCREMENT,
                `phone` varchar(50) NOT NULL,
                `message` text NOT NULL,
                `status` varchar(20) NOT NULL,
                `response` text NOT NULL,
                `date_added` datetime NOT NULL,
                PRIMARY KEY (`log_id`)
            ) ENGINE=MyISAM DEFAULT CHARSET=utf8;");
            $this->db->query("INSERT INTO " . DB_PREFIX . "bdbulksms_notifications_logs SET
                phone = '" . $this->db->escape($phone) . "',
                message = '" . $this->db->escape($message) . "',
                status = '" . $this->db->escape($status) . "',
                response = '" . $this->db->escape($response) . "',
                date_added = NOW()");
        } catch (\Exception $e) {
            // optional: error_log('SMS log insert failed: ' . $e->getMessage());
        }
    }
}
?>
